<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Property extends Model 
{

    protected $table = 'properties';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'type_id', 'advantages_id', 'facilities_id', 'location', 'kitchen_details', 'rooms_details', 'bathroom_details', 'place_rules_ids', 'is_included', 'country_id', 'city_id', 'district_id', 'area', 'tenant_count', 'tenant_gender', 'description_ar', 'description', 'jetroom_type', 'is_updated');

    public function files()
    {
        return $this->morphMany('App\Models\File', 'fileable');
    }

    public function prices()
    {
        return $this->hasMany('App\Models\Price');
    }

    public function bookingTerms()
    {
        return $this->hasMany('App\Models\BookingTerm');
    }

    public function bookings()
    {
        return $this->hasMany('App\Models\Booking');
    }

    public function invoices()
    {
        return $this->hasMany('App\Models\Invoices');
    }

}